/**
 * @file Drv_LVD.c
 * @author 吳星萍 (iris@e-besthealth.com)
 * @brief  LVD Low Voltage Detector 調用接口
 * @version 1.0
 * @date 2020-06-21
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */

#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_LVD.h"
#include "Drv_GPIO.h"
#include "Drv_AFE_ADC.h"

/**
 * @brief 利用ADC 內部Batden 獲取VDD的電壓
 *
 * @return unsigned int VDD的電壓/mV
 */
u32 Drv_LVD()
{
    volatile u32 VDDData;
    VDDData = Drv_GetADC_AVGn(ADC_CHANNEL_AN1, 10);
    VDDData = VDDData *  3300 / 4096; // mV
    return VDDData;
}

//@-------MuFunction3 中斷入口函數-----------@
DEFINE_ISR(MuFunction3_ISR, 0x02c)
{
	if(_lvf==1)
	{
		_lvf=0;	
		//user code
	}
}